% Acquisizione dati
clc
clear all

%Specifica il percorso completo al file CSV
percorso_cartella = 'C:\Users\user\OneDrive\Desktop\GPS\TESI\Risultati_prove_trazione\';
nome_file_csv2 = 'Prova2.xlsx';

% Combina il percorso con il nome del file CSV
percorso_completo2= fullfile(percorso_cartella, nome_file_csv2);

% Leggi il file CSV
dati2 = xlsread(percorso_completo2); % Legge tutto il file CSV

% Estrai le tre colonne di interesse
Spostamenti_output2= dati2(:, 1);
Offset_spostamento2=Spostamenti_output2(1,1);
Spostamenti2=Spostamenti_output2+Offset_spostamento2;
Forza_output2= dati2(:, 2); 
Offset_forza2=Forza_output2(1,1);
Forza2=Forza_output2-Offset_forza2;

%% Plottaggio forza spostamento

figure(1)
plot(Spostamenti2, Forza2, 'r', 'DisplayName', 'Prova2');
grid on
% Aggiungi etichette e legenda
xlabel('\DeltaL');
ylabel('F_t_r_a_z_i_o_n_e');
legend('show');
title('Curva Forza-Spostamenti prova 2');
hold off
% Dati provino
%gage_lenght2=100; %93; %mm
%gage_lenght3=120;
gage_lenght2=93; %93; %mm
gage_lenght3=101.5;
V_deformazione= 1.2; %mm/min
w=13;%mm
%s2=2.5;
 s2=3.1;     %mm
%s3=2.8;
s3=3.2;
A_resistente2=w*s2;
A_resistente3=w*s3;
sigma2=Forza2/A_resistente2;
epsilon2=Spostamenti2/gage_lenght2;

%% grafici sigma epsilon
n=160;
sigma2_E=sigma2(10:n);
epsilon2_E=epsilon2(10:n);

figure(2)
plot(epsilon2, sigma2, 'r', 'DisplayName', 'Prova2','LineWidth',1.5);
grid on

% Aggiungi etichette e legenda
xlabel('\epsilon');
ylabel('\sigma');
legend('show');
hold on

% Calcola la pendenza della retta interpolante
E2 = sum(epsilon2_E .* sigma2_E) / sum(epsilon2_E.^2);

% Crea un vettore x_valutazione per la valutazione della retta interpolante
x_valutazione2 = linspace(min(epsilon2), max(epsilon2), length(epsilon2));  % Intervallo di valutazione

% Calcola i corrispondenti valori di y_valutazione
y_valutati2 = E2 * x_valutazione2;

% Disegna i dati originali e la retta interpolante

plot(x_valutazione2, y_valutati2, 'm', 'DisplayName', '\sigma=E\epsilon','LineWidth',1.5);
plot(x_valutazione2+0.002, y_valutati2, '-.k' ,'DisplayName', 'retta per \sigma_s');
legend('Location', 'Southeast');
title('Curva Stress-Strain prova 2');
grid on;
xlim([epsilon2(1), epsilon2(end)]);
ylim([sigma2(1), max(sigma2)+50]);

%% ricerca fine validita legge hooke
% Trova l'indice in cui il valore supera il 5% del valore di riferimento
indice2 = 1;  % Inizializza l'indice
for i = 20:length(epsilon2)
    if (abs(y_valutati2(i)' -sigma2(i))/sigma2(i)) > 0.05
        indice2 = i;
        break;  % Esci dal ciclo quando il valore supera il 15%
    end
end
plot(epsilon2(indice2),sigma2(indice2), 'ok','DisplayName','\sigma_P','LineWidth',1.5)

%% troviamo Indice rottura
vettoreE2=zeros((length(sigma2)-1),1);
indice2rottura = 1;  % Inizializza l'indice
for i = 2:length(epsilon2)

 vettoreE2(i-1)=((sigma2(i))-sigma2(i-1))./((epsilon2(i))-epsilon2(i-1));
    end
minE2=min(vettoreE2);
min_index2 = find(vettoreE2 == minE2);



%% plottaggio linee tratteggiate sigma snervamento
plot(epsilon2(585),sigma2(585), 'ob','DisplayName','\sigma_s','LineWidth',1.5);
plot(epsilon2(min_index2-1),sigma2(min_index2-1), 'og','DisplayName','\sigma_R','LineWidth',1.5)
sigmaS2=zeros(length(sigma2));
sigmaS2=sigma2(585)+sigmaS2;
set(legend,'AutoUpdate', 'off')
plot(epsilon2, sigmaS2(:,1), '--k')


sigmaverticale2=linspace(min(sigma2), max(sigma2)+50, 1000);
epsilonS2=zeros(length(sigmaverticale2));
epsilonS2=epsilon2(585)+epsilonS2;
plot(epsilonS2(:,1), sigmaverticale2, '--k')

%% plottaggio linee tratteggiate sigma Rottura

sigmaR2=zeros(length(sigma2));
sigmaR2=sigma2(min_index2)+sigmaR2;
set(legend,'AutoUpdate', 'off')
plot(epsilon2, sigmaR2(:,1), '--k')


sigmaverticalerottura2=linspace(min(sigma2), max(sigma2)+50, 1000);
epsilonR2=zeros(length(sigmaverticalerottura2));
epsilonR2=epsilon2(min_index2-1)+epsilonR2;
plot(epsilonR2(:,1), sigmaverticale2, '--k')

%% plottaggio linne che delimitano area di proporzionalità
sigmaP2=zeros(length(sigma2));
sigmaP2=sigma2(indice2)+sigmaP2;
plot(epsilon2, sigmaP2(:,1), '--k')
sigmaverticaleProporzionale2=linspace(min(sigma2), max(sigma2)+50, 1000);
epsilonP2=zeros(length(sigmaverticaleProporzionale2));
epsilonP2=epsilon2(indice2)+epsilonP2;
plot(epsilonP2(:,1), sigmaverticaleProporzionale2, '--k')

%% indichiamo punti sulle ascisse/ordinate
text(epsilonS2(585,1),-10, '\epsilon_S')
text(-0.0013,sigmaS2(585,1), '\sigma_S')
text(epsilon2(min_index2-1,1)-0.0005,-10, '\epsilon_R')
text(-0.0013,sigma2(min_index2-1,1)+15, '\sigma_R')

text(epsilon2(indice2,1)+0.0006,-10, '\epsilon_P')
text(-0.0013,sigma2(indice2,1), '\sigma_P')
%% Colorare areee
% Riempimento dell'area sottesa alla curva in giallo
epsilon2_selezionato = epsilon2(1:indice2)';
sigma2_selezionato = sigma2(1:indice2)';

% Riempimento dell'area sottesa alla curva tra le posizioni 1 e 585 in giallo
x_fill = [epsilon2_selezionato, fliplr(epsilon2_selezionato)]; % Combinazione delle coordinate epsilon2
y_fill = [sigma2_selezionato, zeros(size(sigma2_selezionato))]; % Riempimento fino all'asse x

fill(x_fill, y_fill, 'g','EdgeColor', 'none','FaceAlpha', 0.25);

epsilon2_selezionato = epsilon2(indice2:585)';
sigma2_selezionato = sigma2(indice2:585)';


% Riempimento dell'area sottesa alla curva tra le posizioni 1 e 585 in giallo
x_fill = [epsilon2_selezionato, fliplr(epsilon2_selezionato)]; % Combinazione delle coordinate epsilon2
y_fill = [sigma2_selezionato, zeros(size(sigma2_selezionato))]; % Riempimento fino all'asse x

fill(x_fill, y_fill, 'y','EdgeColor', 'none','FaceAlpha', 0.25); % Colora l'area sottesa alla curva tra le posizioni 1 e 585 in giallo

epsilon2_selezionato = epsilon2(585:end)';
sigma2_selezionato = sigma2(585:end)';
x_fill = [epsilon2_selezionato, fliplr(epsilon2_selezionato)]; % Combinazione delle coordinate epsilon2
y_fill = [sigma2_selezionato, zeros(size(sigma2_selezionato))]; % Riempimento fino all'asse x

fill(x_fill, y_fill, 'b','EdgeColor', 'none','FaceAlpha', 0.1); % Colora l'area sottesa alla curva tra le posizioni 1 e 585 in giallo

hold off;


Allungamento_percetuale=100*(gage_lenght2+Spostamenti2(end)-gage_lenght2)./(gage_lenght2+Spostamenti2(end));


%% Plottaggio forza spostamento

nome_file_csv3 = 'Prova3.xlsx';

% Combina il percorso con il nome del file CSV
percorso_completo3= fullfile(percorso_cartella, nome_file_csv3);

% Leggi il file CSV
dati3 = xlsread(percorso_completo3); % Legge tutto il file CSV

% Estrai le tre colonne di interesse
Spostamenti_output3= dati3(:, 1);
Offset_spostamento3=Spostamenti_output3(1,1);
Spostamenti3=Spostamenti_output3-Offset_spostamento3;
Forza_output3= dati3(:, 2); 
Offset_forza3=Forza_output3(1,1);
Forza3=Forza_output3-Offset_forza3;

figure(3)
plot(Spostamenti3, Forza3, 'r', 'DisplayName', 'Prova3');
grid on
% Aggiungi etichette e legenda
xlabel('\DeltaL');
ylabel('F_t_r_a_z_i_o_n_e');
legend('show');
title('Curva Forza-Spostamenti prova 3');
sigma3=Forza3/A_resistente3;
epsilon3=Spostamenti3/gage_lenght3;
n=160;
sigma3_E=sigma3(10:n);
epsilon3_E=epsilon3(10:n);
hold on 
% Calcola la pendenza della retta interpolante
E3 = sum(epsilon3_E .* sigma3_E) / sum(epsilon3_E.^2);

% Crea un vettore x_valutazione per la valutazione della retta interpolante
x_valutazione3 = linspace(min(epsilon3), max(epsilon3), length(epsilon3));  % Intervallo di valutazione

% Calcola i corrispondenti valori di y_valutazione
y_valutati3 = E3 * x_valutazione3;

hold off
% Disegna i dati originali e la retta interpolante

figure(4)
plot(epsilon2, sigma2, 'r', 'DisplayName', 'Prova2','LineWidth',1.5);
hold on
plot(epsilon3, sigma3, 'b', 'DisplayName', 'Prova3','LineWidth',1.5);
grid on
plot(x_valutazione3, y_valutati3, 'm', 'DisplayName', '\sigma_3=E_3\epsilon_3','LineWidth',1.5);
hold on
% Aggiungi etichette e legenda
xlabel('\epsilon');
ylabel('\sigma');
legend('show');
legend('Location', 'Southeast')
title('Confronto curve Stress-Strain');
xlim([0, epsilon2(end)+0.003]);
ylim([0, max(sigma2)+50]);
hold on


plot(x_valutazione2, y_valutati2, 'g', 'DisplayName', '\sigma_2=E_2\epsilon_2','LineWidth',1.5);

plot(x_valutazione3+0.002, y_valutati3, '-.k' ,'DisplayName', 'retta per \sigma_s3');
plot(x_valutazione2+0.002, y_valutati2, '-k' ,'DisplayName', 'retta per \sigma_s2');
hold off


figure(5)
plot(epsilon3, sigma3, 'r', 'DisplayName', 'Prova3','LineWidth',1.5);
grid on

 % Aggiungi etichette e legenda
xlabel('\epsilon');
ylabel('\sigma');
legend('show');
legend('Location', 'Southeast');
hold on


 
 plot(x_valutazione3, y_valutati3, 'm', 'DisplayName', '\sigma=E\epsilon','LineWidth',1.5);
 plot(x_valutazione3+0.002, y_valutati3, '-.k' ,'DisplayName', 'retta per \sigma_s');
 legend('Location', 'Southeast');
 title('Curva Stress-Strain Prova 3');
 grid on;
 xlim([epsilon3(1), epsilon3(end)]);
 ylim([sigma3(1), max(sigma3)+50]);
% 
%% ricerca fine validita legge hooke
% Trova l'indice in cui il valore supera il 5% del valore di riferimento
indice3 = 1;  % Inizializza l'indice
for i = 20:length(epsilon3)
    if (abs(y_valutati3(i)' -sigma3(i))/sigma3(i)) > 0.05
        indice3 = i;
        break;  % Esci dal ciclo quando il valore supera il 5%
    end
end
plot(epsilon3(indice3),sigma3(indice3), 'ok','DisplayName','\sigma_P','LineWidth',1.5)

%% troviamo Indice rottura
vettoreE3=zeros((length(sigma3)-1),1);
indice3rottura = 1;  % Inizializza l'indice
for i = 2:length(epsilon3)

 vettoreE3(i-1)=((sigma3(i))-sigma3(i-1))./((epsilon3(i))-epsilon3(i-1));
end
minE3=min(vettoreE3);
min_index3 = find(vettoreE3 == minE3);

%% plottaggio linee tratteggiate sigma snervamento
plot(epsilon3(623),sigma3(623), 'ob','DisplayName','\sigma_s','LineWidth',1.5);
plot(epsilon3(min_index3-1),sigma3(min_index3-1), 'og','DisplayName','\sigma_R','LineWidth',1.5)
sigmaS3=zeros(length(sigma3));
sigmaS3=sigma3(623)+sigmaS3;
set(legend,'AutoUpdate', 'off')
plot(epsilon3, sigmaS3(:,1), '--k')
% 
% 
sigmaverticale3=linspace(min(sigma3), max(sigma3)+50, 1000);
 epsilonS3=zeros(length(sigmaverticale3));
 epsilonS3=epsilon3(623)+epsilonS3;
 plot(epsilonS3(:,1), sigmaverticale3, '--k')
% 
 %% plottaggio linee tratteggiate sigma Rottura

 sigmaR3=zeros(length(sigma3));
sigmaR3=sigma3(min_index3)+sigmaR3;
set(legend,'AutoUpdate', 'off')
plot(epsilon3, sigmaR3(:,1), '--k')
sigmaverticalerottura3=linspace(min(sigma3), max(sigma3)+50, 1000);
epsilonR3=zeros(length(sigmaverticalerottura3));
epsilonR3=epsilon3(min_index3-1)+epsilonR3;
plot(epsilonR3(:,1), sigmaverticale3, '--k')
% 
%% plottaggio linee che delimitano area di proporzionalità
sigmaP3=zeros(length(sigma3));
sigmaP3=sigma3(indice3)+sigmaP3;
plot(epsilon3, sigmaP3(:,1), '--k')
sigmaverticaleProporzionale3=linspace(min(sigma3), max(sigma3)+50, 1000);
epsilonP3=zeros(length(sigmaverticaleProporzionale3));
epsilonP3=epsilon3(indice3)+epsilonP3;
plot(epsilonP3(:,1), sigmaverticaleProporzionale3, '--k')

 %% indichiamo punti sulle ascisse/ordinate
 text(epsilonS3(623,1),-10, '\epsilon_S')
text(-0.0013,sigmaS3(623,1), '\sigma_S')
text(epsilon3(min_index3-1,1)+0.0005,-7, '\epsilon_R')
text(-0.0013,sigma3(min_index3-1,1)-10, '\sigma_R')
text(epsilon2(indice2,1)+0.0006,-10, '\epsilon_P')
text(-0.0013,sigma2(indice2,1), '\sigma_P')
%% Colorare areee
% Riempimento dell'area sottesa alla curva in giallo
% Riempimento dell'area sottesa alla curva in giallo
epsilon3_selezionato = epsilon3(1:indice3)';
sigma3_selezionato = sigma3(1:indice3)';

% Riempimento dell'area sottesa alla curva tra le posizioni 1 e 585 in giallo
x_fill = [epsilon3_selezionato, fliplr(epsilon3_selezionato)]; % Combinazione delle coordinate epsilon2
y_fill = [sigma3_selezionato, zeros(size(sigma3_selezionato))]; % Riempimento fino all'asse x

fill(x_fill, y_fill, 'g','EdgeColor', 'none','FaceAlpha', 0.25);


epsilon3_selezionato = epsilon3(indice3:623)';
sigma3_selezionato = sigma3(indice3:623)';
% 
% 
% Riempimento dell'area sottesa alla curva tra le posizioni 1 e 585 in giallo
x_fill3 = [epsilon3_selezionato, fliplr(epsilon3_selezionato)]; % Combinazione delle coordinate epsilon2
 y_fill3 = [sigma3_selezionato, zeros(size(sigma3_selezionato))]; % Riempimento fino all'asse x
% 
fill(x_fill3, y_fill3, 'y','EdgeColor', 'none','FaceAlpha', 0.25); % Colora l'area sottesa alla curva tra le posizioni 1 e 585 in giallo
% 
epsilon3_selezionato = epsilon3(623:end)';
sigma3_selezionato = sigma3(623:end)';
x_fill3 = [epsilon3_selezionato, fliplr(epsilon3_selezionato)]; % Combinazione delle coordinate epsilon2
y_fill3 = [sigma3_selezionato, zeros(size(sigma3_selezionato))]; % Riempimento fino all'asse x
% 
 fill(x_fill3, y_fill3, 'b','EdgeColor', 'none','FaceAlpha', 0.1); % Colora l'area sottesa alla curva tra le posizioni 1 e 585 in giallo
% 
hold off;
% 

% Allungamento_percetuale=100*(gage_lenght2+Spostamenti2(end)-gage_lenght2)./(gage_lenght2+Spostamenti2(end));